#-----------------------------------------------------
#
# Copyright (c) 2017 by cisco Systems, Inc.
# All rights reserved.
#-----------------------------------------------------


__author__ = "vdattatr"

import logging
log = logging.getLogger("runtime.hosting")
from genericresourcemanager import GenericResourceManager
from ..utils.utils import Utils


class ResourceBuilder(object):

    def resource_builder(self,*args):
        platform_type = Utils.getSystemConfigValue('platform', 'resource_manager_name', 'default')

        if(platform_type=='polaris'):
             from polarisresourcemanager import PolarisResourceManager
             return PolarisResourceManager.getInstance(*args)
        else:
             return GenericResourceManager.getInstance(*args)
