__author__ = "madawood"


class CAFAbstractService(object):
    """
    This class defines the basic skeleton for a service to be created in CAF.
    Any service in CAF should adhere to this skeleton defined.
    """

    def __init__(self, *args, **kwargs):
        """
        Will initialize the service
        """
        pass

    def start(self):
        """
        If the service is enabled then service should start and return boolean True,
        if not then method shouldn't run the service and return False
        """
        pass

    def stop(self):
        """
        If service in enabled then try to stop the service.
        If not enabled then do nothing.
        """
        pass

    def set_config(self, config):
        """
        Will stop the service if it is running and validate/update the service config with given config.
        Once config is updated then will try to start the service, only if new config is not disabled the service.
        """
        raise NotImplementedError("Set config is not supported by the service!")

    def get_config(self):
        """
        Will return the config of the given service.
        """
        raise NotImplementedError("Get config is not supported by the service!")

    def is_running(self):
        """
        Will return True if service is running, False if it is not.
        """
        return False

    def validate_config(self, config):
        """
        Basically validate the config given, if it is valid returns True .
        If it is not it will return False.
        """
        pass


class ServiceParams(object):
    def __init__(self, params):
        self._params = params

    @property
    def name(self):
        return self._params['name']

    @property
    def config(self):
        return self._params['config']

    @property
    def config_file(self):
        return self._params['config_file']

