#-----------------------------------------------------
# Connector related resources
# Created on Dec 2nd, 2012
#
# @author: rnethi
#
# Copyright (c) 2012-2013 by cisco Systems, Inc.
# All rights reserved.
#-----------------------------------------------------
'''
 Connector related resources
'''

from jsonencoder import JSONEncoder
from apiservice import ResourceRoute, APIService
from common import AuthenticatedResource, make_response, make_error_response
from connectorconfig import ConnectorConfig
from logsinfo import LogsInfo
from ..utils.cafevent import CAFEvent
from ..utils.infraexceptions import *
from ..utils.utils import Utils
from connector import ConnectorsResource, ConnectorResource

import logging
import tempfile
import os
import falcon
import json
import re

log = logging.getLogger("runtime.api.resources")

jsonencoder = JSONEncoder()

@ResourceRoute("/service-bundles/{app_id}", endpoint="service-bundles")
class ServiceBundleResource(ConnectorResource):
    
    CONNECTOR_FIELDS = {
        'id':   None,
        'name': None,
        'description': None,
        'version': None,
        'author': None,
        'authorLink': None,
        'state': None,
        'is_service' : None,
        'last_state_change_time': None,
        'provides' : None,
        'dependsOn' : None,
        'dependentCartridges' : None,
        'toolkitServicesUsed' : None,
        'appType': None,
        'appCustomOptions' : None,
        'host_mode': None,
        'networkInfo' :  None,
        'resources' :  None
    }
    
    def on_get(self, request, response, app_id):
        
        connectorInfo = APIService.instance.app_manager.get(app_id)
        if connectorInfo is None:
            response = make_error_response(response,
                                            "The application: %s, does not exist" % app_id,
                                            "The application: %s, does not exist" % app_id,
                                            falcon.HTTP_404)
            return

        if not connectorInfo.is_service :
            response = make_error_response(response,
                                            "The %s, is not service" % app_id,
                                            "The %s, is not service" % app_id,
                                            falcon.HTTP_404)
            return

        for k in self.CONNECTOR_FIELDS.keys():
            if hasattr(connectorInfo, k):
                f = getattr(connectorInfo, k)
                self.CONNECTOR_FIELDS[k] = f

        #Get the list of apps/services using this service
        if connectorInfo.provides:
            for service in connectorInfo.provides :
                #Add used-by info
                serviceInfo = APIService.instance.app_manager.get_service_info(service['id'])
                dependency_map = APIService.instance.app_manager.connectorDependency
                service['used_by'] = []
                dependents = []
                connectorNameIdMap = APIService.instance.app_manager.connectorNameIdMap
                dependency_map.resolve_node_dependents((serviceInfo['app_id'], connectorNameIdMap[serviceInfo['app_id']]), dependents)
                for node in dependents:
                    nodeInfo = APIService.instance.app_manager.get(node[0])
                    if not nodeInfo:
                        continue
                    else:
                        if nodeInfo.is_service:
                            container_type = "service"
                        else:
                            container_type = "app"
                    service['used_by'].append({"id": node[0], "type": container_type})

        response.status = falcon.HTTP_200
        response.body = jsonencoder.encode(self.CONNECTOR_FIELDS)
        log.info("response: %s" % response.body)
        response.set_headers({'Content-Type': "application/json",
                              'Cache-Control': "no-cache"})

#
@ResourceRoute("/services", endpoint="services")
class ServicesResource(ConnectorResource):

    def on_get(self, request, response):

        out = jsonencoder.encode(APIService.instance.app_manager.list_services())
        response.body = out


        response.status = falcon.HTTP_200
        log.info("response: %s" % response.body)
        response.set_headers({'Content-Type': "application/json",
                              'Cache-Control': "no-cache"})


