'''
Created on Nov 12, 2012

@author: shawnwan

Copyright (c) 2012-2013 by Cisco Systems, Inc.
All rights reserved.
'''
import json
import falcon

from  processinfo import ProcessInfo
from apiservice import  ResourceRoute
from common import AuthenticatedResource, make_response, make_error_response

@ResourceRoute("/platform/processes", endpoint="platform_processes")
class ProcessResourceHandler(AuthenticatedResource):

    def on_get(self, request, response):
        out = ''
        pinfo = ProcessInfo()
        request_pid = request.get_param("pid")
        if request_pid is None or len(request_pid) == 0:
            out = pinfo.list_processes()
        else:
            out = pinfo.get_process_info(int(request_pid))
        if len(out) == 0:
            response = make_error_response(response,
                                            "Invalid process id: %s", request_pid,
                                            "Invalid process id",
                                            falcon.HTTP_404)
            return

        datastr = json.dumps(out)
        response = make_response(response, datastr, falcon.HTTP_200)
        response.set_header('Content-Type', "application/json")
        response.set_header('Cache-Control', "no-cache")
