import logging
import cgi, time
from appfw.utils.utils import Utils
from appfw.api.token import TokenManager
log = logging.getLogger("runtime.api")



class MultiPartParser(cgi.FieldStorage):

    def __init__(self, *args, **kwargs):
        cgi.FieldStorage.__init__(self, *args, **kwargs)

    def make_file(self, binary=None):
        tmpUploadDir = Utils.getSystemConfigValue('controller', 'upload_dir', '/tmp')
        import tempfile
        return tempfile.TemporaryFile("w+b", dir=tmpUploadDir) 


class MultipartMiddleware(object):

    def __init__(self, parser=None):
        self.parser = parser or MultiPartParser

    def parse(self, stream, environ):
        return self.parser(fp=stream, environ=environ)


    def process_request(self, req, resp, **kwargs):

        if 'multipart/form-data' not in (req.content_type or ''):
            return
        enter = time.time()
        log.debug("Processing multipart request")
        # This must be done to avoid a bug in cgi.FieldStorage.
        req.env.setdefault('QUERY_STRING', '')
        
        form = self.parse(stream=req.stream, environ=req.env)
        for key in form:
            field = form[key]
            if not getattr(field, 'filename', False):
                field = form.getlist(key)
            # TODO: put files in req.files instead when #493 get merged.
            req._params[key] = field
            
        exit = time.time()
        try: 
            duration = exit - enter 
            if duration >= (6 * 60 * 60) and req.get_param("X-Token-Id"):
                log.info("API request took longer than token timeout - %s secs" % duration)
                token = req.get_param("X-Token-Id")
                TokenManager.getInstance().extendToken(token)
                log.info("API request token %s expiry extended" % token)
        except Exception as ex:
            log.error("Failed to extend token timeout with exception %s" % str(ex))
        
            
