#!/bin/sh
#This command deletes the user created for scp 
# Run as root
# Created this script to use delgroup tool instead of groupdel

if [ "$(id -u)" != "0" ]; then
        echo "This script must be run as root" 1>&2
        exit 1
fi
SUCCESS=0
if [ $# -eq 1 ]; then
        username=$1
        deluser "$username"
        if [ $? -eq $SUCCESS ]
        then
                echo "Deleted user $1 from the system"
        else
                echo "Unable to delete the user"
                exit 1
        fi
        delgroup "$username"
else
    echo "Requires username arg to be provided"
    exit 1
fi

exit 0