#!/bin/ash

LOGG_INFO="logger -t IOX-CAF -p user.info"
LOGG_ERR="logger -t IOX-CAF -p user.err"
IOX_DEV_FILE="/home/root/iox/caf/config/device_config.yaml"
CAF_START_LOG="/tmp/iox/iox-caf-start.log"

cgroup_mount_pt=/sys/fs/cgroup

. /usr/bin/platformfunc.sh

echo " Starting caf " > $CAF_START_LOG
if [ -f /var/run/caf.pid ] ; then
    pid=`cat /var/run/caf.pid`
    if [ -e /proc/$pid ]; then
        $LOGG_INFO "It appears that CAF is already running with PID: " $pid
        echo "It looks like caf is already running with $pid" > $CAF_START_LOG
        exit 0
    else
        echo "Caf PID file is already present remvoing caf pid file" >> $CAF_START_LOG
        $LOGG_INFO "CAF PID: $pid is not in running state..."
        $LOGG_INFO "Removing the CAF pid file /var/run/caf.pid"
        rm /var/run/caf.pid

        # Remove pid from cgroup tasks
        echo 0 > $cgroup_mount_pt/cpu/host/caf/tasks
        echo 0 > $cgroup_mount_pt/memory/host/caf/tasks
    fi
fi

VENV_DIR=~/.virtualenvs/CAF
ACTIVATE_ENV=$VENV_DIR/bin/activate
if [ -d $VENV_DIR ]
then
    $LOGG_INFO 'Activating virtualenv at ' $VENV_DIR
    . $ACTIVATE_ENV
fi

# Will check ssl certificates and generate new if needed
SSL_CERT_PATH=/home/root/iox/.certs

if [ ! -d "$SSL_CERT_PATH" ]; then
  mkdir -p $SSL_CERT_PATH
fi


if [ ! -f $SSL_CERT_PATH/ssl.key ] || [ ! -f $SSL_CERT_PATH/ssl.crt ]; then

    ssl_tmp_path=$(mktemp -d "/tmp/cert_dir.XXXXXXXX")

    out=$(openssl genrsa -out $ssl_tmp_path/ssl.key 2048 2>&1)
    if [ $? -eq 0 ]
    then
      $LOGG_INFO "Successfully generated ssh keys"
    else
      $LOGG_ERR "Error while creating ssh keys: $out"
    fi

    CONF=$ssl_tmp_path/openssl.cnf
    if [ ! -f $CONF ]; then
        cat >$CONF <<EOF
[req]
distinguished_name = req_distinguished_name

[ req_distinguished_name ]
# Variable name   Prompt string
#----------------------   ----------------------------------
unstructuredName = unstructured Name
EOF
    fi

    res=$(openssl req -config $CONF -x509 -days 3650 -new -key $ssl_tmp_path/ssl.key -out $ssl_tmp_path/ssl.crt -subj "/unstructuredName=0.0.0.0" 2>&1)
    if [ $? != 0 ]
    then
      $LOGG_ERR "Error while generating cert: $res"
    fi
    #openssl x509 -text -noout -in $ssl_tmp_path/ssl.crt -certopt no_pubkey,no_sigdump
    cp $ssl_tmp_path/ssl.key $SSL_CERT_PATH/ssl.key
    cp $ssl_tmp_path/ssl.crt $SSL_CERT_PATH/ssl.crt
fi

echo " Generated required certificate for caf " >> $CAF_START_LOG
SCRIPT_PATH=/home/root/iox/caf/scripts
CONFIG_PATH=/home/root/iox/caf/config

if [ -f $SCRIPT_PATH/startup.py ] ; then
    STARTUP=$SCRIPT_PATH/startup.py
else
    STARTUP=$SCRIPT_PATH/startup.pyc
fi

if [ -f ${IOX_DEVICE_CONFIG_FILE} ]; then
    cp -f ${IOX_DEVICE_CONFIG_FILE} $IOX_DEV_FILE
fi

if [ -L /storage ];
then
    line=`grep "\/part2\/storage" /home/root/iox/caf/config/system-config.ini | wc -l`
    if [ $line -eq 0 ]; then
        sed -i "s/\/storage\//\/part2\/storage\//g" $CONFIG_PATH/system-config.ini
    fi
fi

PYTHONPATH=/usr/lib/python2.7/site-packages:/usr/lib:/home/root/iox/local/lib python $STARTUP $CONFIG_PATH/system-config.ini $CONFIG_PATH/log-config.ini 2>/dev/null 1>/dev/null &
echo $! > /var/run/caf.pid

# Update cgroup settings
pid=`cat /var/run/caf.pid`
echo $pid > $cgroup_mount_pt/cpu/host/caf/tasks
echo $pid > $cgroup_mount_pt/memory/host/caf/tasks
echo "Started CAF with PID $pid " >> $CAF_START_LOG

exit 0
