#!/bin/bash

VENV_DIR=~/.virtualenvs/CAF
ACTIVATE_ENV=$VENV_DIR/bin/activate
SDIST_CACHE_CAF_RELPATH=../../../third-party/python27/caf
SDIST_CACHE_UT_RELPATH=../../../third-party/python27/ut

SDIST_CACHE_CAF=$(dirname $(readlink -e $SDIST_CACHE_CAF_RELPATH))/$(basename $SDIST_CACHE_CAF_RELPATH)
SDIST_CACHE_UT=$(dirname $(readlink -e $SDIST_CACHE_UT_RELPATH))/$(basename $SDIST_CACHE_UT_RELPATH)

echo $VENV_DIR
if [ ! -d $VENV_DIR ]
then
    echo 'Creating virtualenv at ' $VENV_DIR
    virtualenv $VENV_DIR
fi
echo 'Entering virtualenv ' $VENV_DIR
. $ACTIVATE_ENV
echo 'Local archive path : ' $SDIST_CACHE_CAF
echo 'Local archive path : ', $SDIST_CACHE_UT
echo 'Installing CAF dependencies from local archive '
pip install --find-links=file://$SDIST_CACHE_CAF --find-links=file://$SDIST_CACHE_UT --index-url=file:///dev/null --no-index -r ../config/caf-requirements.txt
echo 'Installing CAF-UT dependencies from local archive'
pip install --find-links=file://$SDIST_CACHE_CAF --find-links=file://$SDIST_CACHE_UT --index-url=file:///dev/null --no-index -r ../config/ut-requirements.txt
echo 'The following packages were installed..'
pip freeze
