'''
Created on Nov 27, 2012

@author: samagraw

Copyright (c) 2012 by Cisco Systems, Inc.
All rights reserved.
'''

import falcon
from apiservice import ResourceRoute
from common import AuthenticatedResource, make_response, add_no_cache_header

from systeminfo import SystemInfo
from jsonencoder import JSONEncoder
jsonencoder = JSONEncoder()

@ResourceRoute("/platform/sysinfo", endpoint="sysinfo")    
class SystemResourceHandler(AuthenticatedResource):

    def on_get(self, request, response):
        brief = request.get_param("brief")
        if isinstance(brief, basestring):
            if brief.lower() == "false":
                brief = False
            elif brief.lower() == "true":
                brief = True
            else:
                brief = False
        else:
            brief = False
        out = jsonencoder.encode(SystemInfo.get_system_info(brief=brief))
        response = make_response(response, out, falcon.HTTP_200)
        response.set_header('Content-Type', "application/json")
        response = add_no_cache_header(response)
