'''
Created on Oct 1, 2017

@author: iyavuz

Copyright (c) 2017 by Cisco Systems, Inc.
All rights reserved.
'''

import falcon

from diagnostic import PlatformDiagnostic
from apiservice import  ResourceRoute
from common import AuthenticatedResource, make_response, make_error_response
from jsonencoder import JSONEncoder
from appfw.utils.infraexceptions import PlatformDiagnosticNotSupported
import logging

log = logging.getLogger("runtime.api.resources")

jsonencoder = JSONEncoder()

@ResourceRoute("/diagnostic", endpoint="diagnostic")
class DiagnosticResourceHandler(AuthenticatedResource):

    def on_get(self, request, response):
                
        type = request.get_param("type")
        detail = request.get_param("detail")
        
        try:
            diag_output = PlatformDiagnostic.collect_diagnostics(type, detail)
            out = jsonencoder.encode(diag_output)
        except PlatformDiagnosticNotSupported as ex:
            log.info("Platform diagnostics not supported.")
            response = make_error_response(response,
                                           ex.message,
                                           "Platform diagnostics not supported.",
                                           falcon.HTTP_501,
                                           ex.errorcode
                                           )
            return
        except Exception as ex:
            log.exception("Error getting diagnostics information.")
            response = make_error_response(response,
                                           ex.message,
                                           "Error getting diagnostics information.",
                                           falcon.HTTP_500
                                           )
            return

        response.body = out
        response.status = falcon.HTTP_200
        response.set_headers({'Content-Type': "application/json",
                              'Cache-Control': "no-cache"})
