import logging
import falcon
import base64

from jsonencoder import JSONEncoder
from apiservice import ResourceRoute, APIService
from common import ResourceBase, AuthenticatedResource, make_error_response

log = logging.getLogger("runtime.api.resources")

jsonencoder = JSONEncoder()
brokerService = APIService.instance.hosting_manager.get_service("broker-service")

@ResourceRoute("/brokersecurity/", endpoint="brokerclient")
class BrokerServiceResource(AuthenticatedResource):

    def on_get(self, req, resp):
        log.debug("BrokerResource.on_get")
        if not brokerService:
            make_error_response(resp, "brokerService is unavailable", "BrokerService is unavailable", falcon.HTTP_503)
            return

        svc_id = req.get_param('svc_id')

        svc_tokens = []
        if svc_id:
            token_obj = brokerService.get_broker_token_for_service(svc_id)
            if token_obj is not None:
                svc_tokens.append(token_obj.serialize())
            else:
                make_error_response(resp, "token for svc_id not found", "token for svc_id not found", falcon.HTTP_404)
                return
        else:
            tokens = brokerService.broker_list_tokens()
            for token in tokens:
                svc_tokens.append(token.serialize())
        resp.body = jsonencoder.encode(svc_tokens)
        resp.status = falcon.HTTP_200

    def on_delete(self, req, resp):
        log.debug("BrokerSecurityResource.on_delete")
        if not brokerService:
            make_error_response(resp, "brokerService is unavailable", "brokerService is unavailable", falcon.HTTP_503)
            return

        svc_id = req.get_param('svc_id')
        if svc_id:
            brokerService.delete_service_broker_token(svc_id)
        else:
            brokerService.purge_all_service_broker_tokens()

        resp.status = falcon.HTTP_204

