__author__ = 'madawood'
import json
import falcon
from common import make_response, make_error_response, add_no_cache_header
from ..runtime.platformcapabilities import PlatformCapabilities
from apiservice import APIService
from apiservice import ResourceRoute
from appfw.utils.utils import Utils
from systemhealthinfo import SystemHealthInfo
import logging

log = logging.getLogger("runtime.api.resources")

class BareResource(object):

    def on_get(self, request, response):
        try:
            pc = PlatformCapabilities.getInstance()
            url_prfix = APIService.instance.API_PATH_PREFIX
            mgmt_api_version = pc.MGMT_API_VERSION
            iox_version = pc.iox_release
            version = Utils.getIOxVersion()
            if url_prfix and mgmt_api_version:
                serialize_data= {
                    "api_info":{
                        "supported_versions":[
                            {
                            "url_prefix": url_prfix,
                            "mgmt_api_version": mgmt_api_version
                            }
                        ]

                    },
                    "version": version,
                    "iox_release": iox_version,
                    "motd": Utils.getMOTD()
                }
                datastr = json.dumps(serialize_data)
                response = make_response(response, datastr, falcon.HTTP_200)
                response.set_header('Content-Type', "application/json")
                response.set_header('Cache-Control', "no-cache")
                response.set_header('Strict-Transport-Security', "max-age=31536000; includeSubDomains; preload")
                response = add_no_cache_header(response)
            else:
                response = make_error_response(response,
                                            "API management version is unable to found",
                                            "API management version is unable to found",
                                            falcon.HTTP_500)
        except Exception as ex:
            response = make_error_response(response,
                                        ex.message,
                                        "Error! while getting the API info",
                                        falcon.HTTP_500)
        return

@ResourceRoute("/health", endpoint="health")
class HealthResource(object):

    def on_get(self, request, response):
        try:
            iox_health = SystemHealthInfo.get_iox_health()
            if iox_health:
                # Send 200 response
                response = make_response(response, "", falcon.HTTP_200)
            else:
                response = make_error_response(response,
                                            "Some of the iox services are not running",
                                            "Some of the iox services are not running",
                                            falcon.HTTP_500)
                
        except Exception as ex:
            log.exception("Error while calling iox health : %s" % str(ex))
            response = make_error_response(response,
                                        ex.message,
                                        "Error! while getting the iox health info",
                                        falcon.HTTP_500)
        return

