#!/bin/sh

#This script creates the  scp user
ROOT_UID=0
SUCCESS=0

# Run as root
if [ "$(id -u)" != "0" ]; then
   echo "This script must be run as root" 1>&2
   exit 1
fi

#test, if both argument are there
if [ $# -eq 1 ]; then
username=$1

	# Check if user already exists.
	grep -c "^$username:" /etc/passwd
	if [ $? -eq $SUCCESS ] 
	then	
		echo "User $username does already exist."
                exit 0
	else
		adduser -D -g "" "$username"
                if [ $? -eq $SUCCESS ]
                then
                    echo "Added the user $1"
                else
                    echo "Unable to add the user"
                    exit 1
                fi
	fi  
	echo "the account for using scp is setup"

else
        echo  " program needs 1 arguments you have given $# "
        echo  " you have to call the script $0 username"
        exit 1
fi

exit 0
