#!/usr/bin/env python
# ----------------------------------------
# Author: Sandeep Puddupakkam (spuddupa)|
# Polaris IoX Sept 2016                 |
# ----------------------------------------
import sys
import os


# CLI HELPER GLOBALS BEGIN
import time
active_exec_prompt = '#'
# CLI HELPER GLOBALS END


class IOSConnect(object):
    """
    TODO: Add description here.
    """
    __singleton = None # the one, true Singleton


    def __new__(cls, *args, **kwargs):
        # Check to see if a __singleton exists already for this class
        # Compare class types instead of just looking for None so
        # that subclasses will create their own __singleton objects
        if cls != type(cls.__singleton):
        #if not cls.__singleton:
            cls.__singleton = \
                super(IOSConnect, cls).__new__(cls, *args, **kwargs)
        return cls.__singleton

    def __init__(self, host, port=23, exec_password="", cli_timeout=10, logger=None):

        self.host = host
        self.port = port
        self.exec_pwd = exec_password
        self.cli_timeout = cli_timeout
        self.mylogger = logger
        self.prompts_list = []

    #Logging helpers
    def logdebug(self, str):
        if self.mylogger:
            self.mylogger.debug(str)
        else:
            print str

    def loginfo(self, str):
        if self.mylogger:
            self.mylogger.info(str)
        else:
            print str

    def logerror(self, str):
        if self.mylogger:
            self.mylogger.error(str)
        else:
            print str

    def logwarn(self, str):
        if self.mylogger:
            self.mylogger.warning(str)
        else:
            print str

    #This function is to rotate the log file.
    def rotate_log_file(self, log_file, instr):
        import logging
        from logging.handlers import RotatingFileHandler
        mylogger = logging.getLogger("clihelper")
        handler = RotatingFileHandler(log_file,"a", maxBytes=100000,
                                      backupCount=1, encoding=None,
                                      delay="true")
        handler.setLevel(logging.DEBUG)
        mylogger.addHandler(handler)
        mylogger.error(instr)
        mylogger.removeHandler(handler)
        handler.close()
        mylogger.shutdown()

    # CLI HELPER CODE BEGIN
    def ios_connect(self):
        import pexpect

        log_file = os.sep.join(["/tmp", "clihelper.log"])
        now = time.strftime("%c")
        mystr=("\n\nNew session created with Host:[%s] Port:[%s] at [%s]\n"
                   % (self.host, self.port, now))
        self.rotate_log_file(log_file, now)
        fout = file(log_file, 'a+')
        self.child = pexpect.spawn('telnet ' + self.host + ' ' + str(self.port), timeout=self.cli_timeout)
        self.child.logfile = fout
        i = self.child.expect(["Escape character is .*\r\n", 'Connection refused'])
        # i=self.child.expect(["IR800>",'Connection refused'])
        self.logdebug('first expect %d' % i)
        if i == 0:
            self.logdebug("Sending empty line...")
            self.child.send('\r\n')
        elif i == 1:
            self.logwarn("Connection refused. Try to clear the line")
            self.child.kill(0)
        self.get_prompt()  # Auto detect prompt.

        self.get_exec_prompt()
        # set terminal len to 0 so that more is not asked.
        if self.prompt in self.prompts_list:
            self.run_cmds(['term len 0'], False)

    def is_alive(self):
        True if self.child and self.child.isalive() else False

    def ask_passwd(self):
        self.logdebug('Asking for password. expecting:%s' % (self.prompt))
        self.child.sendline('en')
        self.child.expect('assword:')
        self.child.sendline(self.exec_pwd)
        self.child.expect(self.prompt)
        self.logdebug('logged in')


    def get_exec_prompt(self):
        import pexpect

        self.child.send('\r\n')
        prompts = []
        prompts = self.prompts_list[:]
        prompts.append(pexpect.EOF)  # index 2
        prompts.append(pexpect.TIMEOUT)  # index 3

        self.logdebug("prompts is:%s" % (prompts))
        i = self.child.expect(prompts, timeout=4)
        self.logdebug('second expect %d' % i)
        if i in range(0, 2):
            self.prompt = prompts[(2 * (i / 2)) + 1]
            if not i % 2:
                self.ask_passwd()
            pass
        elif i == 2:
            self.logwarn("EOF hit")
        elif i == 3:
            self.logwarn("TIMEOUT hit")
            self.logwarn("self.child.before")
            self.logwarn(self.child.before)
            self.logwarn("self.child.after")
            self.logwarn(self.child.after)
        else:
            self.logwarn("No match")
            self.logwarn("self.child.before")
            self.logwarn(self.child.before)
            self.logwarn("self.child.after")
            self.logwarn(self.child.after)
            self.prompt = active_exec_prompt
        self.logdebug('Prompt is [' + self.prompt + ']')


    def get_prompt(self):
        import pexpect
        self.child.send('\r\n')
        prompts = []
        self.prompt = ""
        # prompts = prompts_list[:]
        prompts.append('>')  # index 0
        prompts.append('#')  # index 1
        prompts.append(pexpect.EOF)  # index 2
        prompts.append(pexpect.TIMEOUT)  # index 3

        self.logdebug("prompts is:%s" % (prompts))
        i = self.child.expect(prompts, timeout=4)
        self.logdebug('prompt=[%s]' % self.child.before.strip())
        self.logdebug('expect %d' % i)
        if i in range(0, 1):
            self.prompt = self.child.before.strip()  # remove any newline characters.
            del self.prompts_list[:]
            self.prompts_list.append(self.prompt + ">")
            self.prompts_list.append(self.prompt + "#")
        elif i == 2:
            self.logwarn("EOF hit")
        elif i == 3:
            self.logwarn("TIMEOUT hit")
            self.logwarn("self.child.before")
            self.logwarn(self.child.before)
            self.logwarn("self.child.after")
            self.logwarn(self.child.after)
        else:
            self.logwarn("No match")
            self.logwarn("self.child.before")
            self.logwarn(self.child.before)
            self.logwarn("self.child.after")
            self.logwarn(self.child.after)
            self.prompt = active_exec_prompt
        self.logdebug('Prompt is [' + self.prompt + ']')
        self.logdebug("prompts_list is:" + ','.join(self.prompts_list))


    def run_cmds(self, cmds, print_output=False):
        import pexpect
        for cmd in cmds:
            cmd_str = str(cmd).strip()
            # print('executing: [%s]'%cmd_str)
            self.child.sendline(cmd_str)
        while (self.child.expect([self.prompt, pexpect.TIMEOUT], timeout=self.cli_timeout) == 0)\
                and "\r\n" == self.child.before:
            pass
        if print_output:
            print self.child.before
            sys.stdout.flush()



    def teardown_connection(self):
        global child, host, port
        if self.child and self.child.isalive():
            self.child.kill(0)
            self.child = None
            self.host = None
            self.port = None


    def get_cmds_output(self,cmds):
        import pexpect
        global child, prompt
        for cmd in cmds:
            cmd_str = str(cmd).strip()
            # print('executing: [%s]'%cmd_str)
            self.child.sendline(cmd_str)
        while((self.child.expect([self.prompt, pexpect.TIMEOUT], timeout=self.cli_timeout) == 0)
                            and "\r\n" == self.child.before):
            pass
        output = self.child.before.split("\r\n")
        # Strip out the first line as it is the cmd_str.
        if len(output) > 1:
            del output[0]
        return "\n".join(output)
    # CLI HELPER CODE END


def main():
    myios = IOSConnect("192.168.1.1",exec_password="cisco")
    myios.ios_connect()
    print "Connection is alive:[%r]"%(myios.is_alive())
    myios.run_cmds(["show version"], True)
    #print myios.get_cmds_output(["show run"])
    myios.teardown_connection()
    print "Connection is alive:[%r]"%(myios.is_alive())

    sys.exit(0)
if __name__ == '__main__':
    main()