'''
Created on Jul 14, 2014

@author: utandon

Copyright (c) 2012-2013 by Cisco Systems, Inc.
All rights reserved.
'''
import falcon
import logging
from appfw.runtime.eventsmonitor import EventsMonitor
from apiservice import  ResourceRoute
from common import AuthenticatedResource, make_response, make_error_response
from jsonencoder import JSONEncoder

jsonencoder = JSONEncoder()
events_monitor = EventsMonitor.getInstance()
log = logging.getLogger("runtime.api.resources")

@ResourceRoute("/events", endpoint="events")
class EventsResourceHandler(AuthenticatedResource):

    def on_get(self, request, response):
    
        try:
            from_seq_no = request.get_param("from_sequence_number")
            if from_seq_no is None:
                from_seq_no = "-1"
            from_seq_no = int(from_seq_no)

            to_seq_no = request.get_param("to_sequence_number")
            if to_seq_no is None:
                to_seq_no = "-1"
            to_seq_no = int(to_seq_no)

            count = request.get_param("count")
            if count is None:
                count = "-1"
            count = int(count)

            filter = request.get_param("filter")
        except Exception as ex:
            msg = "Invalid input params - %s" % str(ex)
            log.exception("%s" % msg)
            response = make_error_response(response,
                                           "%s" % msg,
                                           "%s" % msg,
                                           falcon.HTTP_400
                                           )
            return
        
        try:
            events = events_monitor.get_events(from_seq_no, to_seq_no, count, filter)
            out = jsonencoder.encode(events)
        except ValueError as ex:
            msg = "Invalid incoming request - %s" % str(ex)
            log.error("%s" % msg)
            response = make_error_response(response,
                                           "%s" % msg,
                                           "%s" % msg,
                                           falcon.HTTP_400)
            return
        except Exception as ex:
            log.exception("Error while getting events with given parameters.")
            response = make_error_response(response,
                                           ex.message,
                                           "Error while getting events with given parameters.",
                                           falcon.HTTP_500
                                           )
            return
            
        response = make_response(response, out, falcon.HTTP_200)
        response.set_header('Content-Type', "application/json")
        response.set_header('Cache-Control', "no-cache")


    def on_delete(self, request, response):
        '''
        Deletes all the events in events monitor queue 
        '''
        events_monitor.delete_events()
        response.status = falcon.HTTP_200
        response.body = ""
 
